﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Model;
using System.Xml.Serialization;
using System.IO;
using System.Data.Odbc;
using System.Data;

namespace PsgServer
{
    class Products
    {
        #region Fields / Constructs

        SqlConnection sqlcon;
        Server server;

        public Products()
        {            
            server = Utils.server;
            sqlcon = server.sqlcon;
        }

        #endregion

        public void Load(object[] param, string outFileName)
        {
            if (Utils.StringEquals(param[0], Utils.Null))
            {
                DataTable dt = new DataTable("product");

                string cmd = " Select * from products ";

                Utils.LoadView(sqlcon, cmd, ref dt);
                server.Serialize(dt, outFileName);
            }
            else
            {
                ProductsDS ds = new ProductsDS();

                string cmd = string.Format(" Select * from products where id = {0} ", param[0]);

                try
                {
                    sqlcon.Open();
                    Utils.LoadDataSet(sqlcon, ds, cmd, "products");
                }
                catch (Exception ex)
                {
                    server.smsg(ex.Message);
                }
                finally
                {
                    sqlcon.Close();
                }

                server.Serialize<ProductsDS>(ds, outFileName);
            }
        }

        public void Save(string fileXmlEntity)
        {
            ProductsDS be = new ProductsDS();
            be = server.Deserialize<ProductsDS>(fileXmlEntity);

            try
            {
                sqlcon.Open();
                Utils.SaveDataSet(sqlcon, be, "products", "products");
            }
            catch (Exception ex)
            {
                server.smsg(ex.Message);
            }
            finally
            {
                sqlcon.Close();
            }
        }
    }
}
